﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;

namespace CashierCrisis.Graphs
{
    public class GraphGenerator
    {
        private SparseGraph<PathNode, GraphEdge> _graph = new SparseGraph<PathNode, GraphEdge>(false);

        public SparseGraph<PathNode, GraphEdge> Graph
        {
            get { return _graph; }
        }

        public GraphGenerator(int width, int height, int numCellsX, int numCellsY)
        {
            float cellWidth = (float)width / (float)numCellsX;
            float cellHeight = (float)height / (float)numCellsY;

            float midX = cellWidth / 2;
            float midY = cellHeight / 2;

            for(int row = 0; row < numCellsY; ++row)
            {
                for (int col = 0; col < numCellsX; ++col)
                {
                    _graph.AddNode(
                        new PathNode(_graph.NextFreeNodeIndex,
                            new Vector2(midX + (col * cellWidth),
                                        midY + (row * cellHeight))));

                }
            }

            for (int row = 0; row < numCellsY; ++row)
            {
                for (int col = 0; col < numCellsX; ++col)
                {

                }
            }
        }

        public void AddAllNeighborsToGridNode(int rows, int columns, int numCellsX, int numCellsY)
        {
            for (int i = -1; i < 2; i++)
            {
                for (int j = -1; j < 2; i++)
                {
                    int nodeX = columns + j;
                    int nodeY = rows + i;

                    if ((i == 0) && (j == 0)) continue;

                    if (ValidNeighbor(nodeX, nodeY, numCellsX, numCellsY))
                    {
                        Vector2 posNode = _graph.GetNode(rows * numCellsX + columns).Position;
                        Vector2 posNeighbor = _graph.GetNode(nodeY * numCellsY * nodeX).Position;

                        float distance = Vector2.Distance(posNode, posNeighbor);

                        GraphEdge edge = new GraphEdge(
                            rows * numCellsX + columns, 
                            nodeY * numCellsX + nodeX, 
                            distance);

                        _graph.AddEdge(edge);

                        if (!_graph.IsDiGraph)
                        {

                            GraphEdge newEdge = new GraphEdge(
                                nodeY * numCellsX + nodeX,
                                rows * numCellsX + columns,
                                distance);

                            _graph.AddEdge(newEdge);
                        }
                                                       
                    }
                }
            }
        }

        private bool ValidNeighbor(int nodeX, int nodeY, int numCellsX, int numCellsY)
        {
            return !((nodeX < 0) || (nodeX >= numCellsX) || (nodeY < 0) || (nodeY >= numCellsY));
        }

    }

}
